<?php
include '../../routes/conexion.php';
$conexion = new mysqli("localhost:3306", "root", "", "casaazul");

if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['calificaciones']) && isset($_POST['asignatura'])) {
    $id_asignatura = intval($_POST['asignatura']);

    foreach ($_POST['calificaciones'] as $id_estudiante => $notas) {
        $id_estudiante = intval($id_estudiante);

        foreach ($notas as $index => $nota) {
            $nota = floatval($nota);

            // Validación de nota
            if ($nota >= 1 && $nota <= 7) {
                // Verificar si ya existe una nota en esa posición
                $check = $conexion->prepare("SELECT Id_Notas FROM Notas WHERE Id_Estudiantes = ? AND Id_Asignatura = ? AND NumeroNota = ?");
                $check->bind_param("iii", $id_estudiante, $id_asignatura, $index);
                $check->execute();
                $check->store_result();

                if ($check->num_rows > 0) {
                    // Actualizar nota existente
                    $update = $conexion->prepare("UPDATE Notas SET Calificacion = ? WHERE Id_Estudiantes = ? AND Id_Asignatura = ? AND NumeroNota = ?");
                    $update->bind_param("diii", $nota, $id_estudiante, $id_asignatura, $index);
                    $update->execute();
                } else {
                    // Insertar nueva nota
                    $insert = $conexion->prepare("INSERT INTO Notas (Calificacion, NumeroNota, Id_Estudiantes, Id_Asignatura) VALUES (?, ?, ?, ?)");
                    $insert->bind_param("diii", $nota, $id_estudiante, $id_asignatura, $index);
                    $insert->execute();
                }
            }
        }
    }

    echo "<script>alert('Notas guardadas correctamente'); window.location.href='../../views/listadoCursos/kinder.php';</script>";
} else {
    echo "No se recibieron datos válidos.";
}

$conexion->close();
?>
