<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Asistencia por Curso</title>
    <link rel="shortcut icon" href="../../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="../../estilos.css">
    <link rel="stylesheet" href="../../fuentes.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-color: rgb(234, 236, 238);
        }
    </style>
</head>
<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
include '../../routes/conexion.php';
$bs = new conexion();  // crea el objeto
$conn = $bs->conectar();  // ahora sí tienes la conexión en $conn


// Obtener niveles
$niveles = [];
$sql_niveles = "SELECT Id_Niveles, Nombre_Niv FROM niveles";
$result_niveles = $conn->query($sql_niveles);
if ($result_niveles) {
    while ($row = $result_niveles->fetch_assoc()) {
        $niveles[] = $row;
    }
}

// Obtener cursos
$cursos = [];
$sql_cursos = "SELECT Id_Cursos, Codigo_Cursos FROM cursos";
$result_cursos = $conn->query($sql_cursos);
if ($result_cursos) {
    while ($row = $result_cursos->fetch_assoc()) {
        $cursos[] = $row;
    }
}
?>
<nav class="navbar fixed-top">
    <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                style="margin-left: 2px;">
            <span class="navbar-toggler-icon"></span>
        </button>
        <a class="btn btn-outline-danger" href="/CasaAzul/views/vistaadmin.php">
            <span class="material-symbols-outlined">home</span>
        </a>
        <a class="btn btn-secondary" href="/CasaAzul/views/Reportes/vistaadminreportes.php">
            <span class="material-symbols-outlined">reply</span>
        </a>

        <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
             aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
            <div class="offcanvas-header">
                <div class="encode-sans" style="color: rgb(37, 84, 157);">
                    <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rápido</h5>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                    <div class="container text-center">
                        <div class="row align-items-start">
                            <div class="col">
                                <li class="nav-item btn btn-outline-secondary mb-2" style="width: 151px;">
                                    <a class="nav-link active" href="/CasaAzul/views/vistaadminprofes.php">
                                        <span class="material-symbols-outlined">school</span> Profesores
                                    </a>
                                </li>
                                <li class="nav-item btn btn-outline-secondary mb-2" style="width: 151px;">
                                    <a class="nav-link active" href="/CasaAzul/views/vistaadminestudiantes.php">
                                        <span class="material-symbols-outlined">people</span> Estudiantes
                                    </a>
                                </li>
                                <li class="nav-item btn btn-danger" style="width: 151px;">
                                    <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                        <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                    </a>
                                </li>
                            </div>
                            <div class="col">
                                <li class="nav-item btn btn-outline-secondary mb-2" style="width: 151px;">
                                    <a class="nav-link active" href="/CasaAzul/views/vistaadminasignaturas.php">
                                        <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                    </a>
                                </li>
                                <li class="nav-item btn btn-outline-secondary mb-2" style="width: 151px;">
                                    <a class="nav-link active" href="/CasaAzul/views/vistaadmincursos.php">
                                        <span class="material-symbols-outlined">class</span> Cursos
                                    </a>
                                </li>
                            </div>
                        </div>
                    </div>
                </ul>
            </div>
        </div>
    </div>
</nav>

<br><br><br><br><br>

<div class="encode-sans">
    <center>
        <h4><strong>📄 REPORTE DE ASISTENCIA POR CURSO</strong></h4>
    </center>
</div>
    <br>

    <form method="POST" class="row g-3 justify-content-center">
        <div class="col-auto">
            <label for="nivel" class="form-label">Nivel:</label>
            <select name="nivel" id="nivel" class="form-select" required>
                <option value="">Seleccione nivel</option>
                <?php foreach ($niveles as $nivel): ?>
                    <option value="<?= $nivel['Id_Niveles'] ?>"><?= htmlspecialchars($nivel['Nombre_Niv']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto">
            <label for="curso" class="form-label">Curso:</label>
            <select name="curso" id="curso" class="form-select" required>
                <option value="">Seleccione curso</option>
                <?php foreach ($cursos as $curso): ?>
                    <option value="<?= $curso['Id_Cursos'] ?>"><?= htmlspecialchars($curso['Codigo_Cursos']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-auto align-self-end">
            <button type="submit" class="btn btn-primary">Generar Reporte</button>
        </div>
    </form>
    <div class="container">
    <form method="POST" action="../../routes/exportar_excel.php" target="_blank" id="formExcel">
        <input type="hidden" name="nivel" id="nivel_excel">
        <input type="hidden" name="curso" id="curso_excel">
        <button type="submit" class="btn btn-success" id="btnExcel" disabled>
            <span class="material-symbols-outlined" style="vertical-align: middle;">rubric</span>  Generar Excel (.xml)
        </button>
    </form>
</div>
    <br>
<center> <div class="container row g-3 justify-content-center">
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['nivel']) && !empty($_POST['curso'])) {
    $nivel = intval($_POST['nivel']);
    $curso = intval($_POST['curso']);

    // 1. Obtener los estudiantes del curso y nivel
    $sqlEstudiantes = "SELECT e.Id_Estudiantes, e.Nombre_Est, e.Apellido_Est
                   FROM estudiantes e
                   JOIN matricula m ON e.Id_Estudiantes = m.Id_EstudiantesMat
                   WHERE m.Id_NivelesMat = ? AND m.Id_CursosMat = ? AND e.Id_EstadoEst = 1";
$stmtEst = $conn->prepare($sqlEstudiantes);
$stmtEst->bind_param("ii", $nivel, $curso);
$stmtEst->execute();
$resEst = $stmtEst->get_result();

    echo '<div class="table-responsive"><table class="table table-bordered">';
    echo '<thead><tr>
            <th>RUT</th>
            <th>Nombre</th>
            <th>Días Presentes</th>
            <th>Días Ausentes</th>
            <th>Total Registros</th>
            <th>% Asistencia</th>
          </tr></thead><tbody>';

    $total_presentes = 0;
    $total_ausentes = 0;
    $total_asistencias = 0;
    $total_registros = 0;

    while ($est = $resEst->fetch_assoc()) {
    $idEst = $est['Id_Estudiantes']; // Corregido aquí
    // 2. Consultar asistencia del estudiante
    $sqlAsist = "SELECT Id_EstadoAsist FROM asistencia WHERE Id_Estudiantes = ?";
    $stmtAsist = $conn->prepare($sqlAsist);
    $stmtAsist->bind_param("i", $idEst);
    $stmtAsist->execute();
    $resAsist = $stmtAsist->get_result();

    $presentes = 0;
    $ausentes = 0;
    $total = 0;
    while ($row = $resAsist->fetch_assoc()) {
        if ($row['Id_EstadoAsist'] == 1) $presentes++;
        else $ausentes++;
        $total++;
    }
    $porcentaje = $total > 0 ? round(($presentes / $total) * 100, 2) : 0;

    echo '<tr>
            <td>' . htmlspecialchars($est['Id_Estudiantes']) . '</td>
            <td>' . htmlspecialchars($est['Nombre_Est'] . ' ' . $est['Apellido_Est']) . '</td>
            <td>' . $presentes . '</td>
            <td>' . $ausentes . '</td>
            <td>' . $total . '</td>
            <td>' . $porcentaje . '%</td>
          </tr>';

    $total_presentes += $presentes;
    $total_ausentes += $ausentes;
    $total_asistencias += $total;
    $total_registros++;
    $stmtAsist->close();
}
    echo '</tbody></table></div>';

    $porcentaje_general = $total_asistencias > 0 ? round(($total_presentes / $total_asistencias) * 100, 2) : 0;

    echo "<div class='alert alert-info'><strong>Resumen general del curso:</strong><br>
            Total estudiantes: $total_registros<br>
            Total presentes: $total_presentes<br>
            Total ausentes: $total_ausentes<br>
            Porcentaje de asistencia general: $porcentaje_general%
          </div>";

    $stmtEst->close();
    $conn->close();
}
?>

</div>
</div>
</center>

<script>
    // Habilita el botón solo si ya se generó el reporte
    document.addEventListener('DOMContentLoaded', function() {
        const btnExcel = document.getElementById('btnExcel');
        const nivel = document.getElementById('nivel');
        const curso = document.getElementById('curso');
        const nivel_excel = document.getElementById('nivel_excel');
        const curso_excel = document.getElementById('curso_excel');
        // Si ya hay selección y se generó el reporte, habilita el botón
        <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['nivel']) && !empty($_POST['curso'])): ?>
            btnExcel.disabled = false;
            nivel_excel.value = "<?= htmlspecialchars($_POST['nivel']) ?>";
            curso_excel.value = "<?= htmlspecialchars($_POST['curso']) ?>";
        <?php endif; ?>
    });
</script>
</body>
</html>
