<?php
include_once __DIR__ . '/../../routes/conexion.php';
session_start();

if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}

$db = new conexion();
$conn = $db->conectar();

$fechaSeleccionada = $_POST['fecha'] ?? date('Y-m-d');

$sql = "SELECT 
            e.Id_Estudiantes,
            e.Nombre_Est,
            e.Apellido_Est,
            e.Id_EstadoEst,
            a.Id_EstadoAsist
        FROM matricula m
        JOIN estudiantes e ON e.Id_Estudiantes = m.Id_EstudiantesMat
        LEFT JOIN asistencia a ON e.Id_Estudiantes = a.Id_Estudiantes AND a.fecha = ?
        WHERE m.Id_NivelesMat = 3 AND e.Id_EstadoEst = 1";

$stmt = $conn->prepare($sql);
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Error en la preparación de la consulta: " . $conn->error);
}
$stmt->bind_param("s", $fechaSeleccionada);
$stmt->bind_param("s", $fechaSeleccionada);
$stmt->execute();
$result = $stmt->get_result();


$estados = [];
$sqlEstados = "SELECT Id_EstadoAsist, EstadoAsistencia FROM estado_asistencia";
$resEstados = $conn->query($sqlEstados);
if (!$resEstados) {
    die("Error al consultar los estados de asistencia: " . $conn->error);
}
while ($rowEstado = $resEstados->fetch_assoc()) {
    $estados[] = $rowEstado;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registro de Asistencia - (1°) Primero Basico</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <link rel="stylesheet" href="../../estilos.css">
    <link rel="stylesheet" href="../../fuentes.css">
    <link rel="stylesheet" href="../../animacionbtn.css">
    <link rel="shortcut icon" href="../../favicon.ico" type="image/x-icon">
</head>
<style>
    .ausente {
        background-color: lightcoral;
        color: black;
    }

    .presente {
    background-color: lightgreen;
    color: black;
    }
</style>
<body>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php" style="display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">home</span></a>
                <a class="btn btn-secondary" aria-current="page" href="/CasaAzul/views/listadoCursos/primerobas.php" style="display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">reply</span></a>

                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary "
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                        <br><br>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <div class="container mt-4">
    <br><br><br><div class="encode-sans" style=": rgb(37, 84, 157);">
        <h3>
            <center>✍🏻 <strong>REGISTRO DE ASISTENCIA:</strong> Primero Basico</center>
        </h3>

    </div>

    <form method="POST" class="mb-4">
        <center><label for="fecha">Seleccione día de asistencia:</label></center>
        <div class="input-group mb-3" style="width: 300px; text-align: center; margin: auto;">
  <input type="date" name="fecha" id="fechaInput" aria-describedby="button-addon2" class="form-control" value="<?= $fechaSeleccionada ?>" required>
  <button type="submit" aria-describedby="button-addon2" class="btn btn-secondary">Consultar</button>
</div>
    </form>

    <form action="../../routes/registroAsistencia/asistenciaPrimerobas.php" method="POST">
        
    <div class="text-left mb-2">
        <div class="botones">
    <button type="button" id="botonPresentes" class="material-symbols-outlined btn btn-primary btn-animado" style="margin-left: 850px;" data-bs-toggle="tooltip" data-bs-placement="top" title="🟢 Marcar a todos como Presente.">priority</button> <button type="button" id="botonAusentes" class="material-symbols-outlined btn btn-warning btn-animado" style="margin-left: 10px;" data-bs-toggle="tooltip" data-bs-placement="top" title="🟡 Marcar a todos como Ausentes.">dangerous</button> <button type="button" id="botonLimpiar" class="material-symbols-outlined btn btn-secondary btn-animado" style="margin-left: 10px;" data-bs-toggle="tooltip" data-bs-placement="top" title="🧹 Limpiar Asistencia.">mop</button> <button type="button" class="material-symbols-outlined btn btn-success btn-animado" style="margin-left: 10px;" id="btnGuardarAsistencia" data-bs-toggle="tooltip" data-bs-placement="top" title="💾 Guardar/Actualizar Asistencia.">cloud_download</button>
    </div>
    📅 Consultando asistencia del día: <strong><?= date('d/m/Y', strtotime($fechaSeleccionada)) ?></strong>
    <script>
                const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                const tooltipList = [...tooltipTriggerList].map(el => new bootstrap.Tooltip(el));
            </script>
</div>
        <input type="hidden" name="fecha" value="<?= $fechaSeleccionada ?>">
        <div class="table-responsive" style="height: 400px; border-color: gray; border-style: solid; border-width: 0.2px; border-radius: 18px;">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>RUN</th>
                    <th>Nombre del Estudiante</th>
                    <th>Asistencia</th>
                </tr>
            </thead>
            <tbody>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $row['Id_Estudiantes']?></td>
            <td><?= $row['Nombre_Est'] . ' ' . $row['Apellido_Est'] ?></td>
            <td>
                <select name="asistencia[<?= $row['Id_Estudiantes'] ?>]" class="form-select selectAsistencia" required>
                    <option value="" <?= is_null($row['Id_EstadoAsist']) ? 'selected' : '' ?>>Seleccione una opción</option>
                    <?php foreach ($estados as $estado): ?>
                        <option value="<?= $estado['Id_EstadoAsist'] ?>" <?= ($row['Id_EstadoAsist'] == $estado['Id_EstadoAsist']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($estado['EstadoAsistencia']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
    <?php endwhile; ?>
</tbody>
        </table>
        </div>
        <br>
<div class="position-fixed top-0 end-0 p-3" style="z-index: 9999; display: none;" id="toastContainer">
    <div id="asistenciaToast" class="toast align-items-center text-white bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                ✅ Asistencia ha sido guardada exitosamente.
            </div>
        </div>
    </div>
</div>    
    </form>
    </div>
</body>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const toastEl = document.getElementById('asistenciaToast');
        if (toastEl) {
            const toast = new bootstrap.Toast(toastEl);
            toast.show();
        }

        const inputFecha = document.getElementById('fecha');
        if (!inputFecha.value) {
            const hoy = new Date();
            const yyyy = hoy.getFullYear();
            const mm = String(hoy.getMonth() + 1).padStart(2, '0');
            const dd = String(hoy.getDate()).padStart(2, '0');
            inputFecha.value = `${yyyy}-${mm}-${dd}`;
        }
    });
</script>

<script>
document.getElementById('btnGuardarAsistencia').addEventListener('click', function(e) {
    e.preventDefault();
    const form = this.closest('form');
    const formData = new FormData(form);

    fetch(form.action, {
        method: 'POST',
        body: formData
    })
    .then(resp => resp.ok ? resp.text() : Promise.reject('Error en el guardado'))
    .then(data => {
        // Mostrar el Toast
        document.getElementById('toastContainer').style.display = 'block';
        const toastEl = document.getElementById('asistenciaToast');
        const toast = new bootstrap.Toast(toastEl);
        toast.show();
    })
    .catch(err => alert('Hubo un error al guardar la asistencia'));
});
</script>

<script>
  document.getElementById('botonPresentes').addEventListener('click', function() {
    document.querySelectorAll('.selectAsistencia').forEach(function(select) {
      select.value = "1";
    });
  });
</script>
<script>
  document.getElementById('botonAusentes').addEventListener('click', function() {
    document.querySelectorAll('.selectAsistencia').forEach(function(select) {
      select.value = "2";
    });
  });
</script>
<script>
  document.getElementById('botonLimpiar').addEventListener('click', function() {
    document.querySelectorAll('.selectAsistencia').forEach(function(select) {
      select.value = "";
    });
  });
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const fechaInput = document.getElementById('fechaInput');
    const hoy = new Date();
    const yyyy = hoy.getFullYear();
    const mm = String(hoy.getMonth() + 1).padStart(2, '0');
    const dd = String(hoy.getDate()).padStart(2, '0');
    const hoyStr = `${yyyy}-${mm}-${dd}`;

    fechaInput.setAttribute('max', hoyStr);

    if (!fechaInput.value) {
        fechaInput.value = hoyStr;
    }

    fechaInput.addEventListener('input', function () {
        // Obtener el valor del input (YYYY-MM-DD)
        const value = this.value;
        if (!value) {
            this.setCustomValidity('');
            return;
        }
        // Extraer año, mes y día del valor del input
        const [year, month, day] = value.split('-').map(Number);
        // Crear fecha en UTC para evitar problemas de zona horaria
        const selectedDate = new Date(Date.UTC(year, month - 1, day));
        const dayOfWeek = selectedDate.getUTCDay(); // 0 = Domingo, 6 = Sábado

        if (dayOfWeek === 0 || dayOfWeek === 6) {
            this.setCustomValidity('No se permite seleccionar sábados ni domingos.');
        } else {
            this.setCustomValidity('');
        }
    });
});
</script>

</html>
