<?php
include '../routes/conexion.php';
$bs = new conexion();

if (!isset($_GET['id'])) {
    echo "ID de asignatura no proporcionado.";
    exit();
}

$idAsignatura = $_GET['id'];

// CONSULTA PARA OBTENER LOS DATOS DE LA ASIGNATURA
$sqlAsignatura = "SELECT * FROM asignatura WHERE id_asignatura = $idAsignatura";
$resAsignatura = mysqli_query($bs->conector, $sqlAsignatura);

if (!$resAsignatura) {
    die("Error en la consulta de asignatura: " . mysqli_error($bs->conector));
}

$asignatura = mysqli_fetch_assoc($resAsignatura);

$sqlEstado = "SELECT Estado_Asig FROM asignatura WHERE Id_Asignatura = $idAsignatura";
$resEstado = mysqli_query($bs->conector, $sqlEstado);
$estadoAsignatura = 0;
if ($rowEstado = mysqli_fetch_assoc($resEstado)) {
    $estadoAsignatura = $rowEstado['Estado_Asig'];
}

// CONSULTA PARA OBTENER A LOS PROFESORES ASIGNADOS EN LA ASIGNATURA
$bs->sql = "SELECT 
    ap.Id_AsigProfe,
    p.Id_Profesores, 
    p.Nombre_Fun, 
    p.Apellido_Fun, 
    p.Email_Fun,
    c.Codigo_Cursos,
    n.Nombre_Niv,
    ap.fechaAsignacion
FROM asignatura_profesores ap
JOIN profesores p ON ap.Id_Profesores = p.Id_Profesores
JOIN cursos c ON ap.Id_Cursos = c.Id_Cursos
JOIN niveles n ON ap.Id_Niveles = n.Id_Niveles
WHERE ap.Id_Asignatura = $idAsignatura";
$bs->res = mysqli_query($bs->conector, $bs->sql);
$contador=0;


// CONSULTA PARA OBTENER A TODOS LOS PROFESORES PARA FUNCIÓN "ASIGNAR ASIGNATURA"
$sqlTodosProfesores = "SELECT * FROM profesores";
$resTodosProfesores = mysqli_query($bs->conector, $sqlTodosProfesores);

// CONSULTA PARA OBTENER TODOS LOS NIVELES DE LA BDD PARA FUNCIÓN "ASIGNAR ASIGNATURA"
$sqlTodosNiveles = "SELECT * FROM Niveles";
$resTodosNiveles = mysqli_query($bs->conector, $sqlTodosNiveles);

// CONSULTA PARA OBTENER TODOS LOS CURSOS DE LA BDD PARA FUNCIÓN "ASIGNAR ASIGNATURA"
$sqlTodosCursos = "SELECT * FROM Cursos";
$resTodosCursos = mysqli_query($bs->conector, $sqlTodosCursos);


?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionar asignaturas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-4Q6Gf2aSP4eDXB8Miphtr37CMZZQ5oXLH2yaXMJ2w8e2ZtHTl7GptT4jmndRuHDT" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-j1CDi7MgGQ12Z7Qab0qlWQ/Qqz24Gc6BM0thvEMVjHnfYGF0rmFCozFSxQBxwHKO"
        crossorigin="anonymous"></script>
    <link rel="stylesheet" href="../estilos.css">
    <link rel="stylesheet" href="../fuentes.css">
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
</head>

<body>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="btn btn-secondary" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php" style="display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">reply</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>

                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary "
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                        <br><br>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div><br><br><br><br>
    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <h3>
            <center>✍🏻 <strong>GESTIONANDO LA ASIGNATURA:</strong>
                <?= htmlspecialchars($asignatura['Nombre_Asignatura']) ?>
            </center>
        </h3>
    </div><br><br>
    <div class="container-fluid text-center" style="margin-left 15px;">
        <div class="row align-items-start">
            <div class="col" style="padding-left: 15px; padding-top: 15px; padding-right: 15px; padding-bottom: 15px;">
                <div class="encode-sans" style=": rgb(37, 84, 157);">
                    <h4>
                        <center>✅ Asignar Profesor/a y Curso</center>
                    </h4>
                </div><br>
                <form action="../routes/asignar_profesor.php" method="POST">
                    <input type="hidden" name="id_asignatura" value="<?= $idAsignatura ?>">
                    <select name="id_profesor" class="form-select" required>
                        <option value="" selected disabled>Seleccione un profesor</option>
                        <?php while ($prof = mysqli_fetch_assoc($resTodosProfesores)) { ?>
                        <option value="<?= $prof['Id_Profesores'] ?>">(<?= htmlspecialchars($prof['Id_Profesores']) ?>)
                            <?= htmlspecialchars($prof['Nombre_Fun']) ?>
                            <?= htmlspecialchars($prof['Apellido_Fun']) ?>
                        </option>
                        <?php } ?>
                    </select>
                    <select name="id_niveles" class="form-select" required>
                        <option value="" selected disabled>Seleccione un nivel</option>
                        <?php while ($prof = mysqli_fetch_assoc($resTodosNiveles)) { ?>
                        <option value="<?= $prof['Id_Niveles'] ?>">
                            <?= htmlspecialchars($prof['Nombre_Niv']) ?>
                        </option>
                        <?php } ?>
                    </select>
                    <select name="id_cursos" class="form-select" required>
                        <option value="" selected disabled>Seleccione un curso</option>
                        <?php while ($prof = mysqli_fetch_assoc($resTodosCursos)) { ?>
                        <option value="<?= $prof['Id_Cursos'] ?>">
                            <?= htmlspecialchars($prof['Codigo_Cursos']) ?>
                        </option>
                        <?php } ?>

                    </select>
                    <br>
                    <button type="submit" class="btn btn-outline-primary">Asignar</button>
                </form>
            </div>
            <div class="col">
                <div class="encode-sans" style=": rgb(37, 84, 157);">
                    <h4><br>
                        <center>🤵🏻 Profesores Asignados</center>
                    </h4>
                </div><br>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Profesor/a</th>
                                <th scope="col">RUN</th>
                                <th scope="col">Correo Institucional</th>
                                <th scope="col">Curso Asignado</th>
                                <th scope="col">Fecha de Asignación</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
if(mysqli_num_rows($bs->res)>0){
    while($persona = mysqli_fetch_assoc($bs->res)){
        $contador++;
?>
<tr>
    <td><?= $contador ?></td>
    <td><?= htmlspecialchars($persona['Nombre_Fun']) ?> <?= htmlspecialchars($persona['Apellido_Fun']) ?></td>
    <td><?= htmlspecialchars($persona['Id_Profesores']) ?></td>
    <td><?= htmlspecialchars($persona['Email_Fun']) ?></td>
    <td><?= htmlspecialchars($persona['Nombre_Niv']) ?> (<?= htmlspecialchars($persona['Codigo_Cursos']) ?>)</td>
    <td><?= htmlspecialchars($persona['fechaAsignacion']) ?></td>
    <td> <a href="#" class="material-symbols-outlined btn btn-outline-danger">delete</a></td>
</tr>
<?php 
    }
} else { 
    echo '<th colspan="9" class="alert alert-danger text-center"> NO EXISTEN PROFESORES ASIGNADOS EN ESTA ASIGNATURA.</th>';
}
?>

                        </tbody>
                    </table>
                </div>
                </div>
                <div class="col">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h4>
                                <center>🚥 Acciones</center>
                            </h4>
                        </div><br>
                        <form action="../routes/eliminar_asignatura.php" method="POST"
                            onsubmit="return confirm('¿Estás seguro que deseas eliminar esta asignatura?');">
                            <input type="hidden" name="id" value="<?=$idAsignatura?>">
                            <button type="submit" class="btn btn-danger">Eliminar Asignatura</button>
                        </form>
                        <br><br>
                        
                        <div class="d-flex justify-content-center">
    <div class="border rounded p-2" style="width: 190px; background:rgb(49, 53, 186);">
        <h6 style="color: white; font-family: Inherit">Activar/Desactivar Asignatura</h6>
        <div class="d-flex justify-content-center">
            <div class="form-check form-switch">
                <input class="form-check-input toggle-estado" type="checkbox" data-id="<?= $idAsignatura ?>"
                <?= $estadoAsignatura == 1 ? 'checked' : '' ?>>
            </div>
        </div>
    </div>
</div>
                    </div>
                </div>
        </div>
    </div><br><br><br>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const switches = document.querySelectorAll('.toggle-estado');
    
    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const idAsignatura = this.dataset.id;
            const nuevoEstado = this.checked ? 1 : 2;

            fetch('../routes/estado-asignaturas.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `id=${idAsignatura}&estado=${nuevoEstado}`
            })
            .then(response => response.json())
            .then(data => {
                console.log("Respuesta del servidor:", data);
                if (data.success) {
                    location.reload();
                } else {
                    alert("Error al actualizar estado.");
                }
            })
            .catch(error => {
                console.error('Error al actualizar el estado:', error);
            });
        });
    });
});
</script>
</body>
</html>