<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
        crossorigin="anonymous"></script>
    <title>Registro de Notas: Septimo Basico</title>
    <link rel="icon" href="../../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../fuentes.css">
</head>
<style>
            body {
            background-color: rgb(234, 236, 238);
        }

    .container-custom {
        margin-top: 2rem;
        max-width: 100%; /* Cambia el ancho máximo */
        padding: 30px;
}

    .navbar {
        background-color: transparent;
        box-shadow: none !important;
    }

    .container-card {
        margin-left: 200px;
    }

    .table-responsive {
        padding-left: 3rem;
        border-radius: 8px;
        padding-top: 1px;
    }

    .btn-group {
        display: flex;
        gap: 5px;
    }


    table {
        border-collapse: separate;
        border-spacing: 0;
        border-radius: 5px;
        overflow: hidden;
        background-color: white;
    }

    thead th:first-child {
        border-top-left-radius: 5px;
    }

    thead th:last-child {
        border-top-right-radius: 5px;
    }

    tbody tr:last-child td:first-child {
        border-bottom-left-radius: 5px;
    }

    tbody tr:last-child td:last-child {
        border-bottom-right-radius: 5px;
    }

    td,
    th {
        border: 1px solid #ddd;
        padding: 8px;
    }
</style>
<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="btn btn-secondary" aria-current="page" href="/CasaAzul/views/listadoCursos/septimobas.php" style="display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">reply</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                        <br><br>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>

<?php
include '../../routes/conexion.php';
$conexion = new mysqli("localhost:3306", "cca110802_casaazulbd", "CasaAzul", "cca110802_casaazul");
if ($conexion->connect_error) die("Error de conexión: " . $conexion->connect_error);

$conexion->set_charset("utf8mb4");

$id_asignatura = isset($_POST['asignatura']) ? intval($_POST['asignatura']) : 0;
$notas_estudiantes = [];

// Cargar asignaturas
$asignaturas = $conexion->query("SELECT id_asignatura, nombre_asignatura FROM asignatura");

// Cargar estudiantes
$estudiantes_sql = "SELECT e.Id_Estudiantes, e.Nombre_Est, e.Apellido_Est
                    FROM estudiantes e
                    JOIN matricula m ON e.Id_Estudiantes = m.Id_EstudiantesMat
                    WHERE m.Id_NivelesMat = 9";
$estudiantes = $conexion->query($estudiantes_sql);

$nombre_asignatura_seleccionada = ''; // Variable para almacenar el nombre seleccionado

// Cargar notas si hay asignatura seleccionada
if ($id_asignatura > 0) {
    $result = $conexion->query("SELECT Id_Estudiantes, NumeroNota, Calificacion FROM notas WHERE Id_Asignatura = $id_asignatura");
    while ($row = $result->fetch_assoc()) {
        $notas_estudiantes[$row['Id_Estudiantes']][$row['NumeroNota']] = $row['Calificacion'];
    }
}

// Guardar notas si se envían
if (isset($_POST['notas']) && $id_asignatura > 0) {
    foreach ($_POST['notas'] as $id_est => $notas_array) {
        foreach ($notas_array as $numero => $calificacion) {
            $numero = intval($numero);
            $calificacion = floatval($calificacion);
            $id_est = intval($id_est);

            if ($calificacion >= 1 && $calificacion <= 7) {
                $check = $conexion->prepare("SELECT Id_Notas FROM notas WHERE Id_Estudiantes = ? AND Id_Asignatura = ? AND NumeroNota = ?");
                $check->bind_param("iii", $id_est, $id_asignatura, $numero);
                $check->execute();
                $check->store_result();

                if ($check->num_rows > 0) {
                    $update = $conexion->prepare("UPDATE notas SET calificacion = ? WHERE Id_Estudiantes = ? AND Id_Asignatura = ? AND NumeroNota = ?");
                    $update->bind_param("diii", $calificacion, $id_est, $id_asignatura, $numero);
                    $update->execute();
                } else {
                    $insert = $conexion->prepare("INSERT INTO notas (Calificacion, Id_Estudiantes, Id_Asignatura, NumeroNota) VALUES (?, ?, ?, ?)");
                    $insert->bind_param("diii", $calificacion, $id_est, $id_asignatura, $numero);
                    $insert->execute();
                }
            }
        }
    }
    echo "<script>alert('✅ Notas guardadas correctamente'); window.location.href='../../views/listadoCursos/septimobas.php';</script>";
}
?>

<div class="container mt-5">
    <br><br><div class="encode-sans" style=": rgb(37, 84, 157);">
    <h3>
        <center><strong>📝REGISTRO DE NOTAS:</strong> SEPTIMO BASICO</center>
    </h3></div>

    <div class="input-group" style="justify-content: center; width: auto;">
    <form method="POST" class="row g-3 mb-4">
        <div class="col-auto">
            <select name="asignatura" class="form-select" required>
                <option disabled selected>Selecciona una asignatura</option>
            <?php while ($fila = $asignaturas->fetch_assoc()) : ?>
                <option value="<?= $fila['id_asignatura'] ?>" <?= ($id_asignatura == $fila['id_asignatura']) ? 'selected' : '' ?>>
            <?= $fila['nombre_asignatura'] ?>
        </option>
            <?php if ($id_asignatura == $fila['id_asignatura']) {
                $nombre_asignatura_seleccionada = $fila['nombre_asignatura'];
            } ?>
        <?php endwhile; ?>
    </select>
        </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary">Seleccionar</button>
            </div>
        </form></div>
    <div class="texto" style="margin-left: 55px;">
    <h5>Estás viendo las notas de la asignatura: <strong><?= htmlspecialchars($nombre_asignatura_seleccionada) ?></strong></h5>
    </div>
    <div class="texto1" style="margin-left: 55px;">
    </div>
    <?php if ($id_asignatura > 0): ?>
    <form method="POST">
        <input type="hidden" name="asignatura" value="<?= $id_asignatura ?>">
        <div class="table-responsive">
            <table class="table table-bordered bg-white">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Apellido</th>
                        <th>Nombre</th>
                        <?php for ($i = 1; $i <= 8; $i++): ?>
                            <th>Nota <?= $i ?></th>
                        <?php endfor; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($est = $estudiantes->fetch_assoc()) : ?>
                        <tr>
                            <td><?= $est['Id_Estudiantes'] ?></td>
                            <td><?= $est['Apellido_Est'] ?></td>
                            <td><?= $est['Nombre_Est'] ?></td>
                            <?php for ($i = 1; $i <= 8; $i++): ?>
                                <td>
                                    <input type="number" step="0.1" min="1" max="7"
                                           name="notas[<?= $est['Id_Estudiantes'] ?>][<?= $i ?>]"
                                           class="form-control"
                                           value="<?= isset($notas_estudiantes[$est['Id_Estudiantes']][$i]) ? $notas_estudiantes[$est['Id_Estudiantes']][$i] : '' ?>">
                                </td>
                            <?php endfor; ?>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <div class="text-center mt-3">
            <button type="submit" class="btn btn-success">💾 Guardar y actualizar notas en la Base de Datos</button> <a href="/CasaAzul/views/vistaadmincursos.php" class="btn btn-outline-danger">Volver a Cursos</a>
        </div>
    </form>
    <?php endif; ?>

    <div class="text-center mt-4">
        
    </div>
</div>

</body>
</html>
