

<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vista: Administrador - Panel</title>
    <link rel="icon" href="../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="../fuentes.css">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />

    <style>
        body {
            background-color: rgb(234, 236, 238);
        }

        .container-custom {
            margin-top: 2rem;
            width: 700px;
            padding: 30px;
            max-width: 860px;
            border-radius: 8px;
            background-color: rgb(117, 171, 220);
            border-color: black;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.781);
        }


        .encode-sans-titulo {
            font-family: "Encode Sans", sans-serif;
            font-optical-sizing: auto;
            font-weight: 900;
            font-style: normal;
            font-variation-settings:
                "wdth" 100;
        }

        .material-symbols-outlined {
            font-variation-settings:
                'FILL' 0,
                'wght' 400,
                'GRAD' 0,
                'opsz' 48
        }


        .material-symbols-outlined {
            vertical-align: middle;
            margin-right: 5px;
            font-variation-settings:
                'FILL' 0,
                'wght' 400,
                'GRAD' 0,
                'opsz' 48
        }

        .navbar {
            background-color: transparent;
            box-shadow: none !important;
        }

        .icon-text {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            /* Espacio entre el icono y el texto */
        }

            .btn-animado {
        opacity: 0;
        transform: translateY(40px);
        animation: aparecer 0.8s ease forwards;
    }

    /* Animación de aparición */
    @keyframes aparecer {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    </style>
</head>

<body>

<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel" style="height: 440px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rápido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminmantenedor.php">
                                                <span class="material-symbols-outlined">rule_settings</span> Mantenedores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/reportes/vistaadminreportes.php">
                                                <span class="material-symbols-outlined">breaking_news</span> Reportes
                                            </a>
                                        </li>
                                        <div class="col"></div>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;width: 181px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    </div>
    <br><br><br>
    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <h2>
            <center>
                <div id="saludo"></div>
                <h5>Selecciona una opción</h5>
            </center>
        </h2><br><br><br>

    </div>
    <center>
    <div class="container-md">
        <div class="row text-center justify-content-center" style="width: 1100px;">
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/vistaadminprofes.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">assignment_ind</span>
                    </span><br>
                    Profesores
                </a>
            </div>
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/vistaadminestudiantes.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">school</span>
                    </span><br>
                    Estudiantes
                </a>
            </div>
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/vistaadmincursos.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">class</span>
                    </span><br>
                    Cursos
                </a>
            </div>
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/vistaadminasignaturas.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">dictionary</span>
                    </span><br>
                    Asignaturas
                </a>
            </div>
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/vistaadminmantenedor.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">rule_settings</span>
                    </span><br>
                    Mantenedores
                </a>
            </div>
            <div class="col-12 col-md-3 mb-4">
                <a href="/CasaAzul/views/reportes/vistaadminreportes.php" class="btn btn-primary btn-custom w-100 btn-animado"
                    style="padding-top: 25px;padding-bottom: 30px;">
                    <span class="icon-text">
                        <span class="material-symbols-outlined" style="font-size: 36px;">breaking_news</span>
                    </span><br>
                    Reportes
                </a>
            </div>
            <!-- Si tienes más botones, agrégalos aquí para completar los 8 -->
            <div class="col-12 col-md-3 mb-4"></div>
            <div class="col-12 col-md-3 mb-4"></div>
        </div>
    </div>
</center>
    <script>
        const nombre = "<?php echo htmlspecialchars($nombreUsuario); ?>";

        const saludoElement = document.getElementById("saludo");

        const fecha = new Date();
        const hora = fecha.getHours();
        let saludo = "";

        if (hora >= 0 && hora < 12) {
            saludo = "☀️ Buenos días, <?=$nombreUsuario?>";
        } else if (hora >= 12 && hora < 19) {
            saludo = "🌇 Buenas tardes, <?=$nombreUsuario?>";
        } else {
            saludo = "🌙 Buenas noches, <?=$nombreUsuario?>";
        }

        saludoElement.textContent = `${saludo}`;
        //saludoElement.textContent = `${saludo}, ${nombre}`;
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
        crossorigin="anonymous"></script>


</body>

</html>