<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mantenedores - Casa Azul</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js" integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q" crossorigin="anonymous"></script>
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="../estilos.css">
    <link rel="stylesheet" href="../fuentes.css">
    <link rel="stylesheet" href="../animacionbtn.css">
</head>
<?php 
include '../routes/conexion.php';
$bs = new conexion();
$bs->sql = "SELECT * FROM estado_estudiantes";
$bs->res = mysqli_query($bs->conector, $bs->sql);
$contador = 0;

$estprofes = new conexion(); 
$estprofes->sql = "SELECT * FROM estado_profesores";
$estprofes->res = mysqli_query($estprofes->conector, $estprofes->sql);
$contador = 0;

$estasign = new conexion(); 
$estasign->sql = "SELECT * FROM estado_asignatura";
$estasign->res = mysqli_query($estasign->conector, $estasign->sql);
$contador = 0;

$estasist = new conexion(); 
$estasist->sql = "SELECT * FROM estado_asistencia";
$estasist->res = mysqli_query($estasist->conector, $estasist->sql);
$contador = 0;

if (isset($_POST['guardar_estado_estudiantes'])) {
    $nombre_estado = mysqli_real_escape_string($bs->conector, $_POST['nombre_estado_est']);
    if (!empty($nombre_estado)) {
        $sql_insert = "INSERT INTO estado_estudiantes (Estado) VALUES ('$nombre_estado')";
        mysqli_query($bs->conector, $sql_insert);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_cambios_estado_estudiante'])) {
    $id = intval($_POST['editar_estado_id']);
    $nombre = mysqli_real_escape_string($bs->conector, $_POST['editar_nombre_estado']);
    if ($id && !empty($nombre)) {
        $sql_update = "UPDATE estado_estudiantes SET Estado='$nombre' WHERE Id_Estado=$id";
        mysqli_query($bs->conector, $sql_update);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_estado_profesor'])) {
    $nombre_estado_profesor = mysqli_real_escape_string($estprofes->conector, $_POST['nombre_estado_profesor']);
    if (!empty($nombre_estado_profesor)) {
        $sql_insert_profesor = "INSERT INTO estado_profesores (EstadoFun) VALUES ('$nombre_estado_profesor')";
        mysqli_query($estprofes->conector, $sql_insert_profesor);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_estado_asignatura'])) {
    $nombre_estado_asignatura = mysqli_real_escape_string($estasign->conector, $_POST['nombre_estado_asignatura']);
    if (!empty($nombre_estado_asignatura)) {
        $sql_insert_asignatura = "INSERT INTO estado_asignatura (Estado) VALUES ('$nombre_estado_asignatura')";
        mysqli_query($estasign->conector, $sql_insert_asignatura);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_cambios_estado_estudiante'])) {
    $id = intval($_POST['editar_estado_id']);
    $nombre = mysqli_real_escape_string($bs->conector, $_POST['editar_nombre_estado']);
    if ($id && !empty($nombre)) {
        $sql_update = "UPDATE estado_estudiantes SET Estado='$nombre' WHERE Id_Estado=$id";
        mysqli_query($bs->conector, $sql_update);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_cambios_estado_profesores'])) {
    $id = intval($_POST['editar_estado_id']);
    $nombre = mysqli_real_escape_string($bs->conector, $_POST['editar_nombre_estado']);
    if ($id && !empty($nombre)) {
        $sql_update = "UPDATE estado_profesores SET EstadoFun='$nombre' WHERE Id_EstadoFun=$id";
        mysqli_query($bs->conector, $sql_update);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_cambios_estado_asignaturas'])) {
    $id = intval($_POST['editar_estado_id']);
    $nombre = mysqli_real_escape_string($bs->conector, $_POST['editar_nombre_estado']);
    if ($id && !empty($nombre)) {
        $sql_update = "UPDATE estado_asignatura SET Estado='$nombre' WHERE Id_EstadoAsign=$id";
        mysqli_query($bs->conector, $sql_update);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_estado_asistencia'])) {
    $nombre_estado = mysqli_real_escape_string($bs->conector, $_POST['nombre_estado_asistencia']);
    if (!empty($nombre_estado)) {
        $sql_insert = "INSERT INTO estado_asistencia (EstadoAsistencia) VALUES ('$nombre_estado')";
        mysqli_query($bs->conector, $sql_insert);
        // Redirige para evitar reenvío del formulario
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (isset($_POST['guardar_cambios_estado_asistencia'])) {
    $id = intval($_POST['editar_estado_id']);
    $nombre = mysqli_real_escape_string($bs->conector, $_POST['editar_nombre_estado']);
    if ($id && !empty($nombre)) {
        $sql_update = "UPDATE estado_asistencia SET EstadoAsistencia='$nombre' WHERE Id_EstadoAsist=$id";
        mysqli_query($bs->conector, $sql_update);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }
}
?>

<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">
                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel" style="height: 430px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rápido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminmantenedor.php">
                                                <span class="material-symbols-outlined">rule_settings</span> Mantenedores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/reportes/vistaadminreportes.php">
                                                <span class="material-symbols-outlined">breaking_news</span> Reportes
                                            </a>
                                        </li>
                                        <div class="col"></div>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;width: 181px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <br><br><br><br>

    <div class="encode-sans">
        <center>
            <h4><strong>⚙️ MANTENEDORES</strong></h4>
        </center>
        <br><br><br>
        <center>
        <div class="container-md">
            <div class="row text-center" style="width: 1100px;">
                <div class="col-12 col-md-3 mb-4">
                    <!-- ✅ Corregido: activador modal con data-bs-toggle -->
                    <a id="estadoEst" href="#" role="button" data-bs-toggle="modal" data-bs-target="#miModalEst"
                        class="btn btn-warning btn-custom w-30 btn-animado"
                        style="margin-right: 20px;padding: 25px 40px 30px 40px;">
                        <span class="icon-text">
                            <span class="material-symbols-outlined" style="font-size: 36px;">check_box</span>
                        </span><br>
                        Estado de Estudiantes
                    </a>
                </div>
                <div class="col-12 col-md-3 mb-4">
                    <a class="btn btn-warning btn-custom w-30 btn-animado" data-bs-toggle="modal" data-bs-target="#miModalProfes"
                        style="margin-right: 20px;padding: 25px 40px 30px 40px;">
                        <span class="icon-text">
                            <span class="material-symbols-outlined" style="font-size: 36px;">check_box</span>
                        </span><br>
                        Estado de Profesores
                    </a>
                </div>
                <div class="col-12 col-md-3 mb-4">
                    <a class="btn btn-warning btn-custom w-30 btn-animado"  data-bs-toggle="modal" data-bs-target="#miModalAsignaturas"
                        style="margin-right: 20px;padding: 25px 53px 30px 53px;">
                        <span class="icon-text">
                            <span class="material-symbols-outlined" style="font-size: 36px;">check_box</span>
                        </span><br>
                        Estado de Asignaturas
                    </a>
                </div>
                <div class="col-12 col-md-3 mb-4">
                    <a class="btn btn-warning btn-custom w-30 btn-animado"  data-bs-toggle="modal" data-bs-target="#miModalAsistencia"
                        style="margin-right: 20px;padding: 25px 53px 30px 53px;">
                        <span class="icon-text">
                            <span class="material-symbols-outlined" style="font-size: 36px;">settings</span>
                        </span><br>
                        Estado de Reporte de Asistencia
                    </a>
                </div>
            </div>
        </div>
        </center>
    </div>

    <!-- ✅ Modal Estudiantes -->
    <div class="modal fade" id="miModalEst" tabindex="-1" aria-labelledby="miModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="miModalLabel">Estado de Estudiantes</h5>
            <button type="button" class="btn btn-primary" style="margin-left: 20px" data-bs-toggle="modal" data-bs-target="#modalCrearEstado">Crear Estado</button>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Estados</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                if(mysqli_num_rows($bs->res) > 0){
                    while($persona = mysqli_fetch_row($bs->res)){
                        $contador++;
                        ?>
                        <tr>
                            <td><?= $persona[0] ?></td>
                            <td><?= $persona[1] ?></td>
                        </tr>
                        <?php 
                    } 
                } else { 
                    echo '<tr><td colspan="3" class="alert alert-danger text-center">No hay estados registrados en la Base de Datos.</td></tr>';
                }
                ?>
                </tbody>
            </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- ✅ Modal funcional de Profesores -->
    <div class="modal fade" id="miModalProfes" tabindex="-1" aria-labelledby="miModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="miModalLabel">Estado de Profesores</h5>
            <button type="button" class="btn btn-primary" style="margin-left: 20px" data-bs-toggle="modal" data-bs-target="#modalCrearEstadoProfesor">Crear Estado</button>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Estados</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                if(mysqli_num_rows($estprofes->res) > 0){
                    while($persona = mysqli_fetch_row($estprofes->res)){
                        $contador++;
                        ?>
                        <tr>
                            <td><?= $persona[0] ?></td>
                            <td><?= $persona[1] ?></td>
                        </tr>
                        <?php 
                    } 
                } else { 
                    echo '<tr><td colspan="3" class="alert alert-danger text-center">No hay estados registrados en la Base de Datos.</td></tr>';
                }
                ?>
                </tbody>
            </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- ✅ Modal funcional de Asignaturas -->
    <div class="modal fade" id="miModalAsignaturas" tabindex="-1" aria-labelledby="miModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="miModalLabel">Estado de Asignaturas</h5>
            <button type="button" class="btn btn-primary" style="margin-left: 20px" data-bs-toggle="modal" data-bs-target="#modalCrearEstadoAsignatura">Crear Estado</button>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Estados</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                if(mysqli_num_rows($estasign->res) > 0){
                    while($persona = mysqli_fetch_row($estasign->res)){
                        $contador++;
                        ?>
                        <tr>
                            <td><?= $persona[0] ?></td>
                            <td><?= $persona[1] ?></td>
                        </tr>
                        <?php 
                    } 
                } else { 
                    echo '<tr><td colspan="3" class="alert alert-danger text-center">No hay estados registrados en la Base de Datos.</td></tr>';
                }
                ?>
                </tbody>
            </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- ✅ Modal funcional de Asistencia -->
    <div class="modal fade" id="miModalAsistencia" tabindex="-1" aria-labelledby="miModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="miModalLabel">Estados de Asistencia</h5>
            <button type="button" class="btn btn-primary" style="margin-left: 20px" data-bs-toggle="modal" data-bs-target="#modalCrearEstadoAsistencia">Crear Estado</button>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Estados</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                if(mysqli_num_rows($estasist->res) > 0){
                    while($persona = mysqli_fetch_row($estasist->res)){
                        $contador++;
                        ?>
                        <tr>
                            <td><?= $persona[0] ?></td>
                            <td><?= $persona[1] ?></td>
                        </tr>
                        <?php 
                    } 
                } else { 
                    echo '<tr><td colspan="3" class="alert alert-danger text-center">No hay estados registrados en la Base de Datos.</td></tr>';
                }
                ?>
                </tbody>
            </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>


    <!-- Modal para crear nuevo estado -->
<div class="modal fade" id="modalCrearEstado" tabindex="-1" aria-labelledby="modalCrearEstadoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCrearEstadoLabel">Crear Nuevo Estado para Estudiantes</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nombre_estado_est" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="nombre_estado_est" name="nombre_estado_est" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_estado_estudiantes">Guardar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para Editar Estado de Estudiantes -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarEstadoLabel">Editar Estado de Estudiante</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="editar_estado_id" name="editar_estado_id">
          <div class="mb-3">
            <label for="editar_nombre_estado" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="editar_nombre_estado" name="editar_nombre_estado" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_cambios_estado_estudiante">Guardar Cambios</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para Editar Estado de Profesores -->
<div class="modal fade" id="modalEditarEstadoProfes" tabindex="-1" aria-labelledby="modalEditarEstadoProfesLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarEstadoProfesLabel">Editar Estado de Profesores</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="editar_estado_profes_id" name="editar_estado_id">
          <div class="mb-3">
            <label for="editar_nombre_estado_profes" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="editar_nombre_estado_profes" name="editar_nombre_estado" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_cambios_estado_profesores">Guardar Cambios</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para Editar Estado de Asignatura -->
<div class="modal fade" id="modalEditarEstadoAsignatura" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarEstadoLabel">Editar Estado de Asignatura</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="editar_estado_asig_id" name="editar_estado_id">
          <div class="mb-3">
            <label for="editar_nombre_estado_asig" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="editar_nombre_estado_asig" name="editar_nombre_estado" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_cambios_estado_asignaturas">Guardar Cambios</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para crear nuevo estado de profesores -->
<div class="modal fade" id="modalCrearEstadoProfesor" tabindex="-1" aria-labelledby="modalCrearEstadoProfesorLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCrearEstadoProfesorLabel">Crear Nuevo Estado de Profesor</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nombre_estado_profesor" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="nombre_estado_profesor" name="nombre_estado_profesor" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_estado_profesor">Guardar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para crear nuevo estado de asignatura -->
<div class="modal fade" id="modalCrearEstadoAsignatura" tabindex="-1" aria-labelledby="modalCrearEstadoAsignaturaLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCrearEstadoAsignaturaLabel">Crear Nuevo Estado de Asignatura</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nombre_estado_asignatura" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="nombre_estado_asignatura" name="nombre_estado_asignatura" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_estado_asignatura">Guardar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para crear nuevo estado de asistencia -->
<div class="modal fade" id="modalCrearEstadoAsistencia" tabindex="-1" aria-labelledby="modalCrearEstadoAsistenciaLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCrearEstadoAsistenciaLabel">Crear Nuevo Estado de Asistencia</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="nombre_estado_asistencia" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="nombre_estado_asistencia" name="nombre_estado_asistencia" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_estado_asistencia">Guardar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal para Editar Estado de Asistencia -->
<div class="modal fade" id="modalEditarEstadoAsistencia" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarEstadoLabel">Editar Estado de Asistencia</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="editar_estado_asist_id" name="editar_estado_id">
          <div class="mb-3">
            <label for="editar_nombre_estado_asist" class="form-label">Nombre del Estado</label>
            <input type="text" class="form-control" id="editar_nombre_estado_asist" name="editar_nombre_estado" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary" name="guardar_cambios_estado_asistencia">Guardar Cambios</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Estudiantes
  var modalEditarEst = document.getElementById('modalEditarEstado');
  if (modalEditarEst) {
    modalEditarEst.addEventListener('show.bs.modal', function (event) {
      var button = event.relatedTarget;
      var id = button.getAttribute('data-id');
      var nombre = button.getAttribute('data-nombre');
      document.getElementById('editar_estado_id').value = id;
      document.getElementById('editar_nombre_estado').value = nombre;
    });
  }

  // Profesores
  var modalEditarProf = document.getElementById('modalEditarEstadoProfes');
  if (modalEditarProf) {
    modalEditarProf.addEventListener('show.bs.modal', function (event) {
      var button = event.relatedTarget;
      var id = button.getAttribute('data-id');
      var nombre = button.getAttribute('data-nombre');
      document.getElementById('editar_estado_profes_id').value = id;
      document.getElementById('editar_nombre_estado_profes').value = nombre;
    });
  }

  // Asignaturas
  var modalEditarAsig = document.getElementById('modalEditarEstadoAsignatura');
  if (modalEditarAsig) {
    modalEditarAsig.addEventListener('show.bs.modal', function (event) {
      var button = event.relatedTarget;
      var id = button.getAttribute('data-id');
      var nombre = button.getAttribute('data-nombre');
      document.getElementById('editar_estado_asig_id').value = id;
      document.getElementById('editar_nombre_estado_asig').value = nombre;
    });
  }

  // Asistencia
  var modalEditarAsist = document.getElementById('modalEditarEstadoAsistencia');
  if (modalEditarAsist) {
    modalEditarAsist.addEventListener('show.bs.modal', function (event) {
      var button = event.relatedTarget;
      var id = button.getAttribute('data-id');
      var nombre = button.getAttribute('data-nombre');
      document.getElementById('editar_estado_asist_id').value = id;
      document.getElementById('editar_nombre_estado_asist').value = nombre;
    });
  }
});
</script>

</body>
</html>
