<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <title>Vista: Admin - Profesores</title>
    <link rel="icon" href="../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../fuentes.css">
</head>
<?php 
include'../routes/conexion.php';
$bs=new conexion();
$bs->sql = "SELECT p.Id_Profesores, p.Nombre_Fun, p.Apellido_Fun, p.Email_Fun, p.telefono, p.Id_EstadoFun FROM profesores p ORDER BY p.Apellido_Fun ASC;";
$bs->res=mysqli_query($bs->conector,$bs->sql);
$contador=0;

$totalProfesores = 0;
$sqlContador = "SELECT COUNT(*) as total FROM profesores WHERE Id_EstadoFun = 1";
$resultadoContador = mysqli_query($bs->conector, $sqlContador);
if ($resultadoContador && mysqli_num_rows($resultadoContador) > 0) {
    $fila = mysqli_fetch_assoc($resultadoContador);
    $totalProfesores = $fila['total'];
}
 ?>
<?php 
$totalProfesoresDesactivados = 0;
$sqlContadorDesactivados = "SELECT COUNT(*) as total FROM profesores WHERE Id_EstadoFun = 2";
$resultadoContadorDesactivados = mysqli_query($bs->conector, $sqlContadorDesactivados);
if ($resultadoContadorDesactivados && mysqli_num_rows($resultadoContadorDesactivados) > 0) {
    $fila = mysqli_fetch_assoc($resultadoContadorDesactivados);
    $totalProfesoresDesactivados = $fila['total'];
}

 ?>
<style>
body {
    background-color: rgb(234, 236, 238);
}

.container-custom {
    margin-top: 2rem;
    max-width: 100%;
    /* Cambia el ancho máximo */
    padding: 30px;
}

.navbar {
    background-color: rgb(234, 236, 238);
    box-shadow: none !important;
}

.container-card {
    margin-left: 200px;
}

.table-responsive {
    padding-left: 3rem;
    border-radius: 8px;
    padding-top: 1px;
}

.btn-group {
    display: flex;
    gap: 5px;
}

/* Añadimos bordes curvos a la tabla */
table {
    border-collapse: separate;
    /* Esto permite aplicar los bordes curvos */
    border-spacing: 0;
    /* Evitamos espacios entre las celdas */
    border-radius: 15px;
    overflow: hidden;
    background-color: white;
}

thead th:first-child {
    border-top-left-radius: 15px;
    /* Bordes curvos para la primera celda */
}

thead th:last-child {
    border-top-right-radius: 15px;
    /* Bordes curvos para la última celda */
}

tbody tr:last-child td:first-child {
    border-bottom-left-radius: 15px;
    /* Bordes curvos para la última fila */
}

tbody tr:last-child td:last-child {
    border-bottom-right-radius: 15px;
    /* Bordes curvos para la última fila */
}

td,
th {
    border: 1px solid #ddd;
    /* Esto es opcional para añadir bordes entre las celdas */
    padding: 8px;
}
</style>

<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>

    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 470px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <a href="../views/registrarProfesor.php" class="btn btn-primary "
                        style="margin-left: 50px;margin-right: 50px;"><span class="material-symbols-outlined">group_add</span>Crear Nuevo Profesor</a>
                     
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminmantenedor.php">
                                                <span class="material-symbols-outlined">rule_settings</span> Mantenedores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/reportes/vistaadminreportes.php">
                                                <span class="material-symbols-outlined">breaking_news</span> Reportes
                                            </a>
                                        </li>
                                        <div class="col"></div>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;width: 181px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <br><br><br><br><br>
    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <h3>
            <center>📊 <STRong>REGISTRO DE PROFESORES</STRong></center>
        </h3>
    </div>
    <br><br>
    <div class="container text-center">
  <div class="row">
    <div class="col">
      <div class="card shadow rounded-4 border-0" style="background: linear-gradient(135deg, #4A90E2, #007BFF);color: white;width: 350px;margin-left: 80px;">
        <div class="card-body d-flex align-items-center">
            <div class="me-3">
                <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                    badge
                </span>
            </div>
            <div>
                <h6 class="mb-0" style="opacity: 0.8;">N° Total de Profesores Activos</h6>
                <h2 class="fw-bold"><?php echo $totalProfesores; ?></h2>
            </div>
        </div>
    </div>
    </div>
    <div class="col">
        <div class="card shadow rounded-4 border-0" style="background: linear-gradient(135deg,rgb(226, 74, 74),rgb(255, 0, 0));color: white;width: 370px;margin-left: 80px;">
        <div class="card-body d-flex align-items-center">
            <div class="me-3">
                <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                    person_off
                </span>
            </div>
            <div>
                <h6 class="mb-0" style="opacity: 0.8;">N° Total de Profesores Inactivos</h6>
                <h2 class="fw-bold"><?php echo $totalProfesoresDesactivados; ?></h2>
            </div>
        </div>
    </div>
    </div>
  </div>
</div>
    <div class="container-custom" style="margin-top: 0px;">
        <div class="table-responsive" style="margin-right: 30px;">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Apellido</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">Correo Institucional</th>
                        <th scope="col">Telefono</th>
                        <th scope="col" style="width: 88px;">Acciones</th>
                        <th scope="col" style="width: 40px;">Estado</th>
                    </tr>
                </thead>
                <tbody>
                <tbody>
                    <?php 
if(mysqli_num_rows($bs->res)>0){
while($persona=mysqli_fetch_row($bs->res)){
	$contador=$contador+1;
 ?>
                    <tr>
                        <td><?=$persona[0]?></td>
                        <td><?=$persona[3]?></td>
                        <td><?=$persona[1]?></td>
                        <td><?=$persona[2]?></td>
                        <td><?=$persona[4]?></td>
                        <td>
                            <a href="modificarProfesor.php?id=<?=$persona[0]?>" class="material-symbols-outlined btn btn-warning btn-sm">edit</a>
                        </td>
                        <td> 
                            <div class="form-check form-switch">
                            <input class="form-check-input toggle-estado" type="checkbox" data-id="<?=$persona[0]?>"
                            <?= $persona[5] == 1 ? 'checked' : '' ?>>
                            </div></td>
                    </tr>
                    <?php 
    } 
} else { 
    echo '<th colspan="9" class="alert alert-danger text-center">No hay profesores registrados en la Base de datos de Casa Azul.</th>';
}
?>
                </tbody>
            </table>
        </div>
    </div>
</body>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const switches = document.querySelectorAll('.toggle-estado');
    
    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const idProfesor = this.dataset.id;
            const nuevoEstado = this.checked ? 1 : 2;

            fetch('../routes/estado-profesor.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `id=${idProfesor}&estado=${nuevoEstado}`
            })
            .then(response => response.json())
            .then(data => {
                console.log("Respuesta del servidor:", data);
                if (data.success) {
                    location.reload();
                } else {
                    alert("Error al actualizar estado.");
                }
            })
            .catch(error => {
                console.error('Error al actualizar el estado:', error);
            });
        });
    });
});
</script>


</html>