<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <title>Vista: Admin - Estudiantes</title>
    <link rel="icon" href="../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../fuentes.css">
    <link rel="stylesheet" href="../animacionbtn.css">
</head>
<?php 
include'../routes/conexion.php';
$bs=new conexion();
$bs->sql = "
SELECT 
    e.Id_Estudiantes, 
    e.Nombre_Est, 
    e.Apellido_Est, 
    e.Email_Est, 
    e.Telefono_Fijo_Est, 
    e.Telefono_Movil_Est,
    e.Id_EstadoEst,
    m.Id_NivelesMat,
    m.Id_CursosMat,
    n.Nombre_Niv,
    c.Codigo_Cursos
FROM 
    estudiantes e
LEFT JOIN 
    matricula m ON m.Id_EstudiantesMat = e.Id_Estudiantes
LEFT JOIN 
    niveles n ON n.Id_niveles = m.Id_NivelesMat
LEFT JOIN 
    cursos c ON c.Id_Cursos = m.Id_CursosMat
ORDER BY 
    e.Apellido_Est ASC;";
$bs->res=mysqli_query($bs->conector,$bs->sql);
$contador=0;

$totalProfesores = 0;
$sqlContador = "SELECT COUNT(*) as total FROM estudiantes";
$resultadoContador = mysqli_query($bs->conector, $sqlContador);
if ($resultadoContador && mysqli_num_rows($resultadoContador) > 0) {
    $fila = mysqli_fetch_assoc($resultadoContador);
    $totalProfesores = $fila['total'];
}
 ?>
<?php
$totalEstudiantesDesactivados = 0;
$sqlContadorEstDesactivados = "SELECT COUNT(*) as total FROM estudiantes WHERE Id_EstadoEst = 2";
$resultadoEstContadorDesactivado = mysqli_query($bs->conector, $sqlContadorEstDesactivados);
if ($resultadoEstContadorDesactivado && mysqli_num_rows($resultadoEstContadorDesactivado) > 0) {
    $fila = mysqli_fetch_assoc($resultadoEstContadorDesactivado);
    $totalEstudiantesDesactivados = $fila['total'];
}

 ?>
<?php 
$totalEstudiantesActivos = 0;
$sqlContadorEstActivos = "SELECT COUNT(*) as total FROM estudiantes WHERE Id_EstadoEst = 1";
$resultadoEstContadorActivos = mysqli_query($bs->conector, $sqlContadorEstActivos);
if ($resultadoEstContadorActivos && mysqli_num_rows($resultadoEstContadorActivos) > 0) {
    $fila = mysqli_fetch_assoc($resultadoEstContadorActivos);
    $totalEstudiantesActivos = $fila['total'];
}

 ?>

<style>
body {
    background-color: rgb(234, 236, 238);
}

.container-custom {
    margin-top: 2rem;
    max-width: 100%;
    /* Cambia el ancho máximo */
    padding: 30px;
}

.navbar {
    background-color: rgba(234, 236, 238, 0);
    box-shadow: none !important;
}

.container-card {
    margin-left: 200px;
}

.table-responsive {
    padding-left: 3rem;
    border-radius: 8px;
    padding-top: 1px;
}

.btn-group {
    display: flex;
    gap: 5px;
}


table {
    border-collapse: separate;
    border-spacing: 0;
    border-radius: 15px;
    overflow: hidden;
    background-color: white;
}

thead th:first-child {
    border-top-left-radius: 15px;
}

thead th:last-child {
    border-top-right-radius: 15px;
}

tbody tr:last-child td:first-child {
    border-bottom-left-radius: 15px;
}

tbody tr:last-child td:last-child {
    border-bottom-right-radius: 15px;
}

td,
th {
    border: 1px solid #ddd;
    padding: 8px;
}

.table-responsive.expandida {
    height: 500vw !important;
    max-height: 500vw !important;
    left: 50%;
    transform: translateX(-50%);
    position: relative;
    z-index: 10;
    box-shadow: 0 0 20px rgba(0,0,0,0.15);
}
</style>

<body>
    <?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel" style="height: 470px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <a href="../views/registrarEstudiante.php" class="btn btn-primary"
                        style="margin-left: 50px;margin-right: 50px;"><span
                            class="material-symbols-outlined">group_add</span>Crear Nuevo Estudiante</a>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminmantenedor.php">
                                                <span class="material-symbols-outlined">rule_settings</span> Mantenedores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/reportes/vistaadminreportes.php">
                                                <span class="material-symbols-outlined">breaking_news</span> Reportes
                                            </a>
                                        </li>
                                        <div class="col"></div>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;width: 181px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <br><br><br>
    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <h3>
            <strong>
                <center>📊 LISTADO DE ESTUDIANTES ACTUALES</center>
            </strong>
        </h3>
    </div>
    <br><br>
    <div class="container text-center">
  <div class="row">
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg, #4A90E2, #007BFF);color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        diversity_3
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Total Alumnos Matriculados</h6>
                    <h2 class="fw-bold"><?php echo $totalProfesores; ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg,rgb(13, 169, 57),rgb(48, 136, 16));color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        how_to_reg
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Total Alumnos Activos</h6>
                    <h2 class="fw-bold"><?php echo $totalEstudiantesActivos; ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg,rgb(226, 74, 74),rgb(255, 0, 0));color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        account_circle_off
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Total Alumnos Inactivos</h6>
                    <h2 class="fw-bold"><?php echo $totalEstudiantesDesactivados; ?></h2>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>

    <div class="container-custom" style="margin-top: 0px;">
        <button id="expandirTabla" class="btn btn-secondary mb-2">
    <span class="material-symbols-outlined">fullscreen</span> Ampliar/Reducir Tabla
</button>
        <div class="table-responsive" style="height: 350px;border-color: gray;border-style: solid;border-width: 0.2px;border-radius: 18px;padding-left: 0px;">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th scope="col">RUN</th>
                        <th scope="col">Apellido</th>
                        <th scope="col">Nombre</th>
                        <th scope="col">Correo Personal</th>
                        <th scope="col">Telefono Fijo</th>
                        <th scope="col">Telefono Móvil</th>
                        <th scope="col">Nivel</th>
                        <th scope="col">Curso</th>
                        <th scope="col" style="text-align: center; width: 170px;">Acciones</th>
                        <th scope="col" style="width: 50px;"><button id="toggleTodosEstudiantes" class="material-symbols-outlined btn btn-primary mb-3 btn-animado" data-bs-toggle="tooltip" data-bs-placement="top" title="🟢 Activar/Desactivar TODOS los estudiantes.">swipe</button> <script> const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]'); const tooltipList = [...tooltipTriggerList].map(el => new bootstrap.Tooltip(el)); </script>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    
                    <?php 
if(mysqli_num_rows($bs->res)>0){
while($persona=mysqli_fetch_row($bs->res)){
	$contador=$contador+1;
 ?>

                    <tr>
                        <td><?=$persona[0]?></td>
                        <td><?=$persona[2]?></td>
                        <td><?=$persona[1]?></td>
                        <td><?=$persona[3]?></td>
                        <td><?=$persona[4]?></td>
                        <td><?=$persona[5]?></td>
                        <td><?=$persona[9]?></td>
                        <td><?=$persona[10]?></td>
                        <td>
                            <center><a href="modificarEstudiante.php?id=<?= $persona[0] ?>"class="btn btn-warning btn-sm material-symbols-outlined" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip" data-bs-title="Editar datos del Estudiante.">edit</a>
                            <a href="../views/modificarCursoEst.php?id=<?= $persona[0] ?>" class="btn btn-success btn-sm material-symbols-outlined" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip" data-bs-title="Editar Nivel/Curso del Estudiante.">bookmark</a>
                            <button type="button" class="btn btn-danger btn-sm material-symbols-outlined" data-bs-toggle="modal" data-bs-target="#exampleModal<?= $persona[0] ?>" title="Eliminar estudiante">delete</button></center>
                        <td>
                            <div class="form-check form-switch">
                            <input class="form-check-input toggle-estado" type="checkbox" data-id="<?=$persona[0]?>"
                            <?= $persona[6] == 1 ? 'checked' : '' ?>>
                            </div></td>
                        </td>
                    </tr>

                    <!-- Modal único por estudiante -->
                    <div class="modal fade" id="exampleModal<?= $persona[0] ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel<?= $persona[0] ?>" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form action="../routes/eliminarestudiante.php?id=<?= $persona[0] ?>" method="POST">
                                    <div class="modal-header">
                                        <h1 class="modal-title fs-5">⚠️ Eliminación de Estudiante</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $persona[0] ?>">
                                    <div class="modal-body">
                                        ¿Estás seguro que deseas eliminar a este estudiante? <strong>(ACCIÓN
                                            IRREVERSIBLE)</strong>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Rechazar
                                            acción</button>
                                        <button type="submit" class="btn btn-danger">Eliminar estudiante</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                } else {
                    echo '<tr><td colspan="12" class="text-center alert alert-danger"><strong>No existen estudiantes registrados en este momento.</strong></td></tr>';
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
<script>
document.getElementById('toggleTodosEstudiantes').addEventListener('click', function () {
    const confirmacion = confirm("¿Estás seguro de que quieres activar/desactivar a todos los estudiantes?");
    if (!confirmacion) return;

    fetch('../routes/activartodoestudiantes.php', {
        method: 'POST',
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload(); // refresca para mostrar cambios
    })
    .catch(error => {
        console.error('Error:', error);
        alert("Ocurrió un error al actualizar el estado.");
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Tu código para switches (no lo muevas)
    const switches = document.querySelectorAll('.toggle-estado');
    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const idEstudiante = this.dataset.id;
            const nuevoEstado = this.checked ? 1 : 2;
            fetch('../routes/estado-estudiante.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `id=${idEstudiante}&estado=${nuevoEstado}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert("Error al actualizar estado.");
                }
            })
            .catch(error => {
                console.error('Error al actualizar el estado:', error);
            });
        });
    });
});
</script>
<script>
document.getElementById('expandirTabla').addEventListener('click', function () {
    const tabla = document.querySelector('.table-responsive');
    tabla.classList.toggle('expandida');
});
</script>

</html>